/*
 * Decompiled with CFR 0.152.
 */
package toni.immersivedamageindicators.foundation;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;

public class IrisCompat {
    private static final MethodHandle SHADERS_ENABLED;
    private static final MethodHandle SHADERS_OPEN_SCREEN;

    public static boolean areShadersEnabled() {
        if (SHADERS_ENABLED != null) {
            try {
                return SHADERS_ENABLED.invokeExact();
            }
            catch (Throwable e) {
                return false;
            }
        }
        return false;
    }

    public static boolean isShaderModPresent() {
        return SHADERS_ENABLED != null;
    }

    static {
        MethodHandle shadersEnabled = null;
        MethodHandle shaderOpenScreen = null;
        try {
            Class<?> irisApiClass = Class.forName("net.irisshaders.iris.api.v0.IrisApi");
            Method instanceGetter = irisApiClass.getDeclaredMethod("getInstance", new Class[0]);
            Object irisApiInstance = instanceGetter.invoke(null, new Object[0]);
            shadersEnabled = MethodHandles.lookup().unreflect(irisApiClass.getDeclaredMethod("isShaderPackInUse", new Class[0])).bindTo(irisApiInstance);
            shaderOpenScreen = MethodHandles.lookup().unreflect(irisApiClass.getDeclaredMethod("openMainIrisScreenObj", Object.class)).bindTo(irisApiInstance);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        SHADERS_ENABLED = shadersEnabled;
        SHADERS_OPEN_SCREEN = shaderOpenScreen;
    }
}

